<?php 
header("Content-Type: application/json");
require 'db_config.php';

// Receive item data
$name = $_POST['name'] ?? '';
$description = $_POST['description'] ?? null;
$location = $_POST['location'] ?? null;
$status = $_POST['status'] ?? '';
$imageUrl = $_POST['imageUrl'] ?? null;   // Cloudinary URL
$userId = $_POST['userId'] ?? '';

$category = $_POST['category'] ?? null;
$contactPhone = $_POST['contactPhone'] ?? null;
$contactEmail = $_POST['contactEmail'] ?? null;

// Required fields check
if (empty($name) || empty($status) || empty($userId)) {
    echo json_encode([
        "status" => "error",
        "message" => "Missing required fields"
    ]);
    exit();
}

// Insert item into database
$stmt = $conn->prepare("
    INSERT INTO items 
    (name, description, location, imageUrl, status, userId, category, contactPhone, contactEmail)
    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)
");

$stmt->bind_param(
    "sssssssss",
    $name,
    $description,
    $location,
    $imageUrl,
    $status,
    $userId,
    $category,
    $contactPhone,
    $contactEmail
);

if ($stmt->execute()) {

    // ---------------------------------------------------------------
    // ✅ SEND PUSHER BEAMS NOTIFICATION
    // ---------------------------------------------------------------

    $notificationData = [
        'title' => "New $status Item Added",
        'body'  => "$name was posted in Lost & Found!"
    ];

    $ch = curl_init("https://lostandfound.heliohost.us/send_notification.php"); // change URL to your domain
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $notificationData);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_exec($ch);
    curl_close($ch);

    // ---------------------------------------------------------------

    echo json_encode(["status" => "success"]);

} else {
    echo json_encode([
        "status" => "error", 
        "message" => $stmt->error
    ]);
}

$stmt->close();
$conn->close();
?>
