<?php
header("Content-Type: application/json");
require 'db_config.php';

$userId = $_GET['userId'] ?? null;

if ($userId) {
    $stmt = $conn->prepare("SELECT * FROM items WHERE userId = ? ORDER BY id DESC");
    $stmt->bind_param("s", $userId);
} else {
    $stmt = $conn->prepare("SELECT * FROM items ORDER BY id DESC");
}

$stmt->execute();
$result = $stmt->get_result();

$items = [];
while ($row = $result->fetch_assoc()) {
    $items[] = $row;
}

echo json_encode([
    "status" => "success",
    "items" => $items
]);

$stmt->close();
$conn->close();
?>
